<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Video_Quiz_Leaderboard extends Model
{
    use HasFactory;

    protected $table = 'tbl_video_quiz_leaderboard';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'category_id' => 'integer',
        'skill_id' => 'integer',
        'classification_id' => 'integer',
        'level_id' => 'integer',
        'total_questions' => 'integer',
        'questions_attended' => 'integer',
        'correct_answers' => 'integer',
        'percentage' => 'integer',
        'winning_coin' => 'integer',
        'status' => 'integer',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
    public function skill()
    {
        return $this->belongsTo(Skill::class, 'skill_id');
    }
    public function classification()
    {
        return $this->belongsTo(Classification::class, 'classification_id');
    }
    public function level()
    {
        return $this->belongsTo(Level::class, 'level_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
